﻿using System;
using System.ComponentModel;
using System.Drawing;
using System.Reflection;
using System.Windows.Forms;

namespace GTDevmonSample
{
    class GTDevmonSampleDlg : Form
    {
		
		private System.ComponentModel.IContainer components = null;

		protected override void Dispose(bool disposing)
		{
			if (disposing && (components != null))
			{
				components.Dispose();
			}
			base.Dispose(disposing);
		}

		#region Windows フォーム デザイナで生成されたコード

		/// <summary>
		/// デザイナ サポートに必要なメソッドです。このメソッドの内容を
		/// コード エディタで変更しないでください。
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(GTDevmonSampleDlg));
			this.GBDeviceNumLabel = new System.Windows.Forms.Label();
			this.GDDeviceNumLabel = new System.Windows.Forms.Label();
			this.GSDeviceNumLabel = new System.Windows.Forms.Label();
			this.GBDeviceWriteLabel = new System.Windows.Forms.Label();
			this.GBDeviceReadLabel = new System.Windows.Forms.Label();
			this.GDDeviceReadLabel = new System.Windows.Forms.Label();
			this.GDDeviceWriteLabel = new System.Windows.Forms.Label();
			this.GSDeviceReadLabel = new System.Windows.Forms.Label();
			this.GSDeviceWriteLabel = new System.Windows.Forms.Label();
			this.CloseButton = new System.Windows.Forms.Button();
			this.GBDeviceGroup = new System.Windows.Forms.GroupBox();
			this.GBDeviceReadEdit = new System.Windows.Forms.TextBox();
			this.GBDeviceWriteOff = new System.Windows.Forms.Button();
			this.GBDeviceWriteOn = new System.Windows.Forms.Button();
			this.GBDeviceNumberEdit = new System.Windows.Forms.NumericUpDown();
			this.GDDeviceGroup = new System.Windows.Forms.GroupBox();
			this.GDDeviceReadEdit = new System.Windows.Forms.TextBox();
			this.GDDeviceNumberEdit = new System.Windows.Forms.NumericUpDown();
			this.GDDeviceWriteButton = new System.Windows.Forms.Button();
			this.GDDeviceWriteEdit = new System.Windows.Forms.NumericUpDown();
			this.GSDeviceGroup = new System.Windows.Forms.GroupBox();
			this.GSDeviceReadEdit = new System.Windows.Forms.TextBox();
			this.GSDeviceWriteEdit = new System.Windows.Forms.NumericUpDown();
			this.GSDeviceNumberEdit = new System.Windows.Forms.NumericUpDown();
			this.GSDeviceWriteButton = new System.Windows.Forms.Button();
			this.StartButton = new System.Windows.Forms.Button();
			this.GTDeviceTimer = new System.Windows.Forms.Timer(this.components);
			this.GTDeviceToolTip = new System.Windows.Forms.ToolTip(this.components);
			this.GTDeviceStatus = new System.Windows.Forms.StatusBar();
			this.GTDeviceStatusLabel = new System.Windows.Forms.StatusBarPanel();
			this.GTDeviceStatusMessage = new System.Windows.Forms.StatusBarPanel();
			this.GTDeviceStatusMapping = new System.Windows.Forms.StatusBarPanel();
			this.GBDeviceGroup.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.GBDeviceNumberEdit)).BeginInit();
			this.GDDeviceGroup.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.GDDeviceNumberEdit)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.GDDeviceWriteEdit)).BeginInit();
			this.GSDeviceGroup.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.GSDeviceWriteEdit)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.GSDeviceNumberEdit)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.GTDeviceStatusLabel)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.GTDeviceStatusMessage)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.GTDeviceStatusMapping)).BeginInit();
			this.SuspendLayout();
			// 
			// GBDeviceNumLabel
			// 
			this.GBDeviceNumLabel.AutoSize = true;
			this.GBDeviceNumLabel.Location = new System.Drawing.Point(20, 16);
			this.GBDeviceNumLabel.Name = "GBDeviceNumLabel";
			this.GBDeviceNumLabel.Size = new System.Drawing.Size(63, 13);
			this.GBDeviceNumLabel.TabIndex = 2;
			this.GBDeviceNumLabel.Text = "Device No.:";
			// 
			// GDDeviceNumLabel
			// 
			this.GDDeviceNumLabel.AutoSize = true;
			this.GDDeviceNumLabel.Location = new System.Drawing.Point(20, 16);
			this.GDDeviceNumLabel.Name = "GDDeviceNumLabel";
			this.GDDeviceNumLabel.Size = new System.Drawing.Size(63, 13);
			this.GDDeviceNumLabel.TabIndex = 10;
			this.GDDeviceNumLabel.Text = "Device No.:";
			// 
			// GSDeviceNumLabel
			// 
			this.GSDeviceNumLabel.AutoSize = true;
			this.GSDeviceNumLabel.Location = new System.Drawing.Point(20, 16);
			this.GSDeviceNumLabel.Name = "GSDeviceNumLabel";
			this.GSDeviceNumLabel.Size = new System.Drawing.Size(63, 13);
			this.GSDeviceNumLabel.TabIndex = 18;
			this.GSDeviceNumLabel.Text = "Device No.:";
			// 
			// GBDeviceWriteLabel
			// 
			this.GBDeviceWriteLabel.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GBDeviceWriteLabel.AutoSize = true;
			this.GBDeviceWriteLabel.Location = new System.Drawing.Point(190, 17);
			this.GBDeviceWriteLabel.Name = "GBDeviceWriteLabel";
			this.GBDeviceWriteLabel.Size = new System.Drawing.Size(66, 13);
			this.GBDeviceWriteLabel.TabIndex = 4;
			this.GBDeviceWriteLabel.Text = "Write Value:";
			// 
			// GBDeviceReadLabel
			// 
			this.GBDeviceReadLabel.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GBDeviceReadLabel.AutoSize = true;
			this.GBDeviceReadLabel.Location = new System.Drawing.Point(190, 47);
			this.GBDeviceReadLabel.Name = "GBDeviceReadLabel";
			this.GBDeviceReadLabel.Size = new System.Drawing.Size(66, 13);
			this.GBDeviceReadLabel.TabIndex = 7;
			this.GBDeviceReadLabel.Text = "Read Value:";
			// 
			// GDDeviceReadLabel
			// 
			this.GDDeviceReadLabel.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GDDeviceReadLabel.AutoSize = true;
			this.GDDeviceReadLabel.Location = new System.Drawing.Point(190, 47);
			this.GDDeviceReadLabel.Name = "GDDeviceReadLabel";
			this.GDDeviceReadLabel.Size = new System.Drawing.Size(66, 13);
			this.GDDeviceReadLabel.TabIndex = 15;
			this.GDDeviceReadLabel.Text = "Read Value:";
			// 
			// GDDeviceWriteLabel
			// 
			this.GDDeviceWriteLabel.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GDDeviceWriteLabel.AutoSize = true;
			this.GDDeviceWriteLabel.Location = new System.Drawing.Point(190, 17);
			this.GDDeviceWriteLabel.Name = "GDDeviceWriteLabel";
			this.GDDeviceWriteLabel.Size = new System.Drawing.Size(66, 13);
			this.GDDeviceWriteLabel.TabIndex = 12;
			this.GDDeviceWriteLabel.Text = "Write Value:";
			// 
			// GSDeviceReadLabel
			// 
			this.GSDeviceReadLabel.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GSDeviceReadLabel.AutoSize = true;
			this.GSDeviceReadLabel.Location = new System.Drawing.Point(190, 47);
			this.GSDeviceReadLabel.Name = "GSDeviceReadLabel";
			this.GSDeviceReadLabel.Size = new System.Drawing.Size(66, 13);
			this.GSDeviceReadLabel.TabIndex = 23;
			this.GSDeviceReadLabel.Text = "Read Value:";
			// 
			// GSDeviceWriteLabel
			// 
			this.GSDeviceWriteLabel.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GSDeviceWriteLabel.AutoSize = true;
			this.GSDeviceWriteLabel.Location = new System.Drawing.Point(190, 17);
			this.GSDeviceWriteLabel.Name = "GSDeviceWriteLabel";
			this.GSDeviceWriteLabel.Size = new System.Drawing.Size(66, 13);
			this.GSDeviceWriteLabel.TabIndex = 20;
			this.GSDeviceWriteLabel.Text = "Write Value:";
			// 
			// CloseButton
			// 
			this.CloseButton.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.CloseButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.CloseButton.Location = new System.Drawing.Point(133, 260);
			this.CloseButton.Name = "CloseButton";
			this.CloseButton.Size = new System.Drawing.Size(100, 25);
			this.CloseButton.TabIndex = 25;
			this.CloseButton.Text = "&Close";
			this.GTDeviceToolTip.SetToolTip(this.CloseButton, "Close the dialog");
			// 
			// GBDeviceGroup
			// 
			this.GBDeviceGroup.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.GBDeviceGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																						this.GBDeviceReadEdit,
																						this.GBDeviceWriteOff,
																						this.GBDeviceWriteOn,
																						this.GBDeviceReadLabel,
																						this.GBDeviceWriteLabel,
																						this.GBDeviceNumberEdit,
																						this.GBDeviceNumLabel});
			this.GBDeviceGroup.Location = new System.Drawing.Point(12, 13);
			this.GBDeviceGroup.Name = "GBDeviceGroup";
			this.GBDeviceGroup.Size = new System.Drawing.Size(431, 76);
			this.GBDeviceGroup.TabIndex = 1;
			this.GBDeviceGroup.TabStop = false;
			this.GBDeviceGroup.Text = "GB Device";
			// 
			// GBDeviceReadEdit
			// 
			this.GBDeviceReadEdit.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GBDeviceReadEdit.Location = new System.Drawing.Point(261, 43);
			this.GBDeviceReadEdit.Name = "GBDeviceReadEdit";
			this.GBDeviceReadEdit.ReadOnly = true;
			this.GBDeviceReadEdit.Size = new System.Drawing.Size(79, 20);
			this.GBDeviceReadEdit.TabIndex = 8;
			this.GBDeviceReadEdit.Text = "0";
			this.GBDeviceReadEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// GBDeviceWriteOff
			// 
			this.GBDeviceWriteOff.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GBDeviceWriteOff.Location = new System.Drawing.Point(346, 11);
			this.GBDeviceWriteOff.Name = "GBDeviceWriteOff";
			this.GBDeviceWriteOff.Size = new System.Drawing.Size(79, 25);
			this.GBDeviceWriteOff.TabIndex = 6;
			this.GBDeviceWriteOff.Text = "OFF";
			this.GTDeviceToolTip.SetToolTip(this.GBDeviceWriteOff, "Turn GB device OFF");
			this.GBDeviceWriteOff.Click += new System.EventHandler(this.GBDeviceWriteOff_Click);
			// 
			// GBDeviceWriteOn
			// 
			this.GBDeviceWriteOn.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GBDeviceWriteOn.Location = new System.Drawing.Point(261, 11);
			this.GBDeviceWriteOn.Name = "GBDeviceWriteOn";
			this.GBDeviceWriteOn.Size = new System.Drawing.Size(79, 25);
			this.GBDeviceWriteOn.TabIndex = 5;
			this.GBDeviceWriteOn.Text = "ON";
			this.GTDeviceToolTip.SetToolTip(this.GBDeviceWriteOn, "Turn GB device ON");
			this.GBDeviceWriteOn.Click += new System.EventHandler(this.GBDeviceWriteOn_Click);
			// 
			// GBDeviceNumberEdit
			// 
			this.GBDeviceNumberEdit.ImeMode = System.Windows.Forms.ImeMode.Disable;
			this.GBDeviceNumberEdit.Location = new System.Drawing.Point(88, 14);
			this.GBDeviceNumberEdit.Maximum = new System.Decimal(new int[] {
																			   65535,
																			   0,
																			   0,
																			   0});
			this.GBDeviceNumberEdit.Name = "GBDeviceNumberEdit";
			this.GBDeviceNumberEdit.Size = new System.Drawing.Size(79, 20);
			this.GBDeviceNumberEdit.TabIndex = 3;
			this.GBDeviceNumberEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.GBDeviceNumberEdit.Validating += new System.ComponentModel.CancelEventHandler(this.GBDeviceNumberEdit_Validating);
			this.GBDeviceNumberEdit.ValueChanged += new System.EventHandler(this.GBDeviceNumberEdit_ValueChanged);
			// 
			// GDDeviceGroup
			// 
			this.GDDeviceGroup.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.GDDeviceGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																						this.GDDeviceReadEdit,
																						this.GDDeviceNumberEdit,
																						this.GDDeviceWriteButton,
																						this.GDDeviceNumLabel,
																						this.GDDeviceWriteLabel,
																						this.GDDeviceWriteEdit,
																						this.GDDeviceReadLabel});
			this.GDDeviceGroup.Location = new System.Drawing.Point(12, 95);
			this.GDDeviceGroup.Name = "GDDeviceGroup";
			this.GDDeviceGroup.Size = new System.Drawing.Size(431, 76);
			this.GDDeviceGroup.TabIndex = 9;
			this.GDDeviceGroup.TabStop = false;
			this.GDDeviceGroup.Text = "GD Device";
			// 
			// GDDeviceReadEdit
			// 
			this.GDDeviceReadEdit.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GDDeviceReadEdit.Location = new System.Drawing.Point(261, 43);
			this.GDDeviceReadEdit.Name = "GDDeviceReadEdit";
			this.GDDeviceReadEdit.ReadOnly = true;
			this.GDDeviceReadEdit.Size = new System.Drawing.Size(79, 20);
			this.GDDeviceReadEdit.TabIndex = 16;
			this.GDDeviceReadEdit.Text = "0";
			this.GDDeviceReadEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// GDDeviceNumberEdit
			// 
			this.GDDeviceNumberEdit.ImeMode = System.Windows.Forms.ImeMode.Disable;
			this.GDDeviceNumberEdit.Location = new System.Drawing.Point(88, 14);
			this.GDDeviceNumberEdit.Maximum = new System.Decimal(new int[] {
																			   65535,
																			   0,
																			   0,
																			   0});
			this.GDDeviceNumberEdit.Name = "GDDeviceNumberEdit";
			this.GDDeviceNumberEdit.Size = new System.Drawing.Size(79, 20);
			this.GDDeviceNumberEdit.TabIndex = 11;
			this.GDDeviceNumberEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.GDDeviceNumberEdit.Validating += new System.ComponentModel.CancelEventHandler(this.GDDeviceNumberEdit_Validating);
			this.GDDeviceNumberEdit.ValueChanged += new System.EventHandler(this.GDDeviceNumberEdit_ValueChanged);
			// 
			// GDDeviceWriteButton
			// 
			this.GDDeviceWriteButton.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GDDeviceWriteButton.Location = new System.Drawing.Point(346, 11);
			this.GDDeviceWriteButton.Name = "GDDeviceWriteButton";
			this.GDDeviceWriteButton.Size = new System.Drawing.Size(79, 25);
			this.GDDeviceWriteButton.TabIndex = 14;
			this.GDDeviceWriteButton.Text = "Write";
			this.GTDeviceToolTip.SetToolTip(this.GDDeviceWriteButton, "Write the value into GD device");
			this.GDDeviceWriteButton.Click += new System.EventHandler(this.GDDeviceWriteButton_Click);
			// 
			// GDDeviceWriteEdit
			// 
			this.GDDeviceWriteEdit.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GDDeviceWriteEdit.ImeMode = System.Windows.Forms.ImeMode.Disable;
			this.GDDeviceWriteEdit.Location = new System.Drawing.Point(261, 15);
			this.GDDeviceWriteEdit.Maximum = new System.Decimal(new int[] {
																			  32767,
																			  0,
																			  0,
																			  0});
			this.GDDeviceWriteEdit.Minimum = new System.Decimal(new int[] {
																			  32768,
																			  0,
																			  0,
																			  -2147483648});
			this.GDDeviceWriteEdit.Name = "GDDeviceWriteEdit";
			this.GDDeviceWriteEdit.Size = new System.Drawing.Size(79, 20);
			this.GDDeviceWriteEdit.TabIndex = 13;
			this.GDDeviceWriteEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.GTDeviceToolTip.SetToolTip(this.GDDeviceWriteEdit, "The value to be written into GD device");
			this.GDDeviceWriteEdit.Validating += new System.ComponentModel.CancelEventHandler(this.GDDeviceWriteEdit_Validating);
			// 
			// GSDeviceGroup
			// 
			this.GSDeviceGroup.Anchor = ((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.GSDeviceGroup.Controls.AddRange(new System.Windows.Forms.Control[] {
																						this.GSDeviceReadEdit,
																						this.GSDeviceWriteEdit,
																						this.GSDeviceNumberEdit,
																						this.GSDeviceWriteButton,
																						this.GSDeviceNumLabel,
																						this.GSDeviceWriteLabel,
																						this.GSDeviceReadLabel});
			this.GSDeviceGroup.Location = new System.Drawing.Point(12, 178);
			this.GSDeviceGroup.Name = "GSDeviceGroup";
			this.GSDeviceGroup.Size = new System.Drawing.Size(431, 76);
			this.GSDeviceGroup.TabIndex = 17;
			this.GSDeviceGroup.TabStop = false;
			this.GSDeviceGroup.Text = "GS Device";
			// 
			// GSDeviceReadEdit
			// 
			this.GSDeviceReadEdit.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GSDeviceReadEdit.Location = new System.Drawing.Point(261, 43);
			this.GSDeviceReadEdit.Name = "GSDeviceReadEdit";
			this.GSDeviceReadEdit.ReadOnly = true;
			this.GSDeviceReadEdit.Size = new System.Drawing.Size(79, 20);
			this.GSDeviceReadEdit.TabIndex = 24;
			this.GSDeviceReadEdit.Text = "0";
			this.GSDeviceReadEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// GSDeviceWriteEdit
			// 
			this.GSDeviceWriteEdit.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GSDeviceWriteEdit.ImeMode = System.Windows.Forms.ImeMode.Disable;
			this.GSDeviceWriteEdit.Location = new System.Drawing.Point(261, 15);
			this.GSDeviceWriteEdit.Maximum = new System.Decimal(new int[] {
																			  32767,
																			  0,
																			  0,
																			  0});
			this.GSDeviceWriteEdit.Minimum = new System.Decimal(new int[] {
																			  32768,
																			  0,
																			  0,
																			  -2147483648});
			this.GSDeviceWriteEdit.Name = "GSDeviceWriteEdit";
			this.GSDeviceWriteEdit.Size = new System.Drawing.Size(79, 20);
			this.GSDeviceWriteEdit.TabIndex = 21;
			this.GSDeviceWriteEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.GTDeviceToolTip.SetToolTip(this.GSDeviceWriteEdit, "The value to be written into GS device");
			this.GSDeviceWriteEdit.Validating += new System.ComponentModel.CancelEventHandler(this.GSDeviceWriteEdit_Validating);
			// 
			// GSDeviceNumberEdit
			// 
			this.GSDeviceNumberEdit.ImeMode = System.Windows.Forms.ImeMode.Disable;
			this.GSDeviceNumberEdit.Location = new System.Drawing.Point(88, 14);
			this.GSDeviceNumberEdit.Maximum = new System.Decimal(new int[] {
																			   2047,
																			   0,
																			   0,
																			   0});
			this.GSDeviceNumberEdit.Name = "GSDeviceNumberEdit";
			this.GSDeviceNumberEdit.Size = new System.Drawing.Size(79, 20);
			this.GSDeviceNumberEdit.TabIndex = 19;
			this.GSDeviceNumberEdit.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			this.GSDeviceNumberEdit.Validating += new System.ComponentModel.CancelEventHandler(this.GSDeviceNumberEdit_Validating);
			this.GSDeviceNumberEdit.ValueChanged += new System.EventHandler(this.GSDeviceNumberEdit_ValueChanged);
			// 
			// GSDeviceWriteButton
			// 
			this.GSDeviceWriteButton.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.GSDeviceWriteButton.Location = new System.Drawing.Point(346, 11);
			this.GSDeviceWriteButton.Name = "GSDeviceWriteButton";
			this.GSDeviceWriteButton.Size = new System.Drawing.Size(79, 25);
			this.GSDeviceWriteButton.TabIndex = 22;
			this.GSDeviceWriteButton.Text = "Write";
			this.GTDeviceToolTip.SetToolTip(this.GSDeviceWriteButton, "Write the value into GS device");
			this.GSDeviceWriteButton.Click += new System.EventHandler(this.GSDeviceWriteButton_Click);
			// 
			// StartButton
			// 
			this.StartButton.Anchor = System.Windows.Forms.AnchorStyles.Bottom;
			this.StartButton.Location = new System.Drawing.Point(239, 260);
			this.StartButton.Name = "StartButton";
			this.StartButton.Size = new System.Drawing.Size(100, 25);
			this.StartButton.TabIndex = 0;
			this.StartButton.Text = "&Start monitor";
			this.GTDeviceToolTip.SetToolTip(this.StartButton, "Start/Stop the device monitor");
			this.StartButton.Click += new System.EventHandler(this.StartButton_Click);
			// 
			// GTDeviceTimer
			// 
			this.GTDeviceTimer.Tick += new System.EventHandler(this.GTDeviceTimer_Tick);
			// 
			// GTDeviceStatus
			// 
			this.GTDeviceStatus.Location = new System.Drawing.Point(0, 291);
			this.GTDeviceStatus.Name = "GTDeviceStatus";
			this.GTDeviceStatus.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																							  this.GTDeviceStatusLabel,
																							  this.GTDeviceStatusMessage,
																							  this.GTDeviceStatusMapping});
			this.GTDeviceStatus.ShowPanels = true;
			this.GTDeviceStatus.Size = new System.Drawing.Size(461, 24);
			this.GTDeviceStatus.SizingGrip = false;
			this.GTDeviceStatus.TabIndex = 26;
			// 
			// GTDeviceStatusLabel
			// 
			this.GTDeviceStatusLabel.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.GTDeviceStatusLabel.Width = 10;
			// 
			// GTDeviceStatusMessage
			// 
			this.GTDeviceStatusMessage.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.GTDeviceStatusMessage.Width = 431;
			// 
			// GTDeviceStatusMapping
			// 
			this.GTDeviceStatusMapping.Alignment = System.Windows.Forms.HorizontalAlignment.Center;
			this.GTDeviceStatusMapping.Width = 20;
			// 
			// GTDevmonSampleDlg
			// 
			this.AcceptButton = this.StartButton;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.CloseButton;
			this.ClientSize = new System.Drawing.Size(461, 315);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.GTDeviceStatus,
																		  this.StartButton,
																		  this.GSDeviceGroup,
																		  this.GDDeviceGroup,
																		  this.GBDeviceGroup,
																		  this.CloseButton});
			this.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.Name = "GTDevmonSampleDlg";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "GT DeviceMonitor";
			this.Closing += new System.ComponentModel.CancelEventHandler(this.GTDevmonSampleDlg_Closing);
			this.Closed += new System.EventHandler(this.GTDevmonSampleDlg_FormClosed);
			this.GBDeviceGroup.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.GBDeviceNumberEdit)).EndInit();
			this.GDDeviceGroup.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.GDDeviceNumberEdit)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.GDDeviceWriteEdit)).EndInit();
			this.GSDeviceGroup.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.GSDeviceWriteEdit)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.GSDeviceNumberEdit)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.GTDeviceStatusLabel)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.GTDeviceStatusMessage)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.GTDeviceStatusMapping)).EndInit();
			this.ResumeLayout(false);

		}

		#endregion

		private System.Windows.Forms.Button CloseButton;
		private System.Windows.Forms.GroupBox GBDeviceGroup;
		private System.Windows.Forms.GroupBox GDDeviceGroup;
		private System.Windows.Forms.GroupBox GSDeviceGroup;
		private System.Windows.Forms.Button StartButton;
		private System.Windows.Forms.TextBox GBDeviceReadEdit;
		private System.Windows.Forms.Button GBDeviceWriteOff;
		private System.Windows.Forms.Button GBDeviceWriteOn;
		private System.Windows.Forms.NumericUpDown GBDeviceNumberEdit;
		private System.Windows.Forms.NumericUpDown GDDeviceNumberEdit;
		private System.Windows.Forms.NumericUpDown GSDeviceNumberEdit;
		private System.Windows.Forms.TextBox GDDeviceReadEdit;
		private System.Windows.Forms.Button GDDeviceWriteButton;
		private System.Windows.Forms.TextBox GSDeviceReadEdit;
		private System.Windows.Forms.Button GSDeviceWriteButton;
		private System.Windows.Forms.Timer GTDeviceTimer;
		private System.Windows.Forms.NumericUpDown GDDeviceWriteEdit;
		private System.Windows.Forms.NumericUpDown GSDeviceWriteEdit;
		private System.Windows.Forms.ToolTip GTDeviceToolTip;
		private System.Windows.Forms.StatusBar GTDeviceStatus;
		private System.Windows.Forms.StatusBarPanel GTDeviceStatusLabel;
		private System.Windows.Forms.StatusBarPanel GTDeviceStatusMessage;
		private System.Windows.Forms.StatusBarPanel GTDeviceStatusMapping;
		private System.Windows.Forms.Label GBDeviceNumLabel;
		private System.Windows.Forms.Label GDDeviceNumLabel;
		private System.Windows.Forms.Label GSDeviceNumLabel;
		private System.Windows.Forms.Label GBDeviceWriteLabel;
		private System.Windows.Forms.Label GBDeviceReadLabel;
		private System.Windows.Forms.Label GDDeviceReadLabel;
		private System.Windows.Forms.Label GDDeviceWriteLabel;
		private System.Windows.Forms.Label GSDeviceReadLabel;
		private System.Windows.Forms.Label GSDeviceWriteLabel;


        private GDev Device;

        private DialogResult Message_NotReady()
        {
            return MessageBox.Show("The monitor is out of operation.\n(Start the monitor)", Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
        }

        private DialogResult Message_AskDisconnect()
        {
            return MessageBox.Show("The monitor is about to be discontinued.\nIs it OK to proceed?", Text, MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation);
        }

        private DialogResult Message_AskConnect()
        {
            return MessageBox.Show("The monitor is about to be started.\nIs it OK?", Text, MessageBoxButtons.OKCancel, MessageBoxIcon.Exclamation);
        }

        private DialogResult Message_ErrConnect()
        {
            return MessageBox.Show("GT SoftGOT2000 has not been started.\n(Cannot access the internal device)", Text, MessageBoxButtons.OK, MessageBoxIcon.Stop);
        }

		private DialogResult Message_ErrRangeShort()
		{
			return MessageBox.Show("Please enter an integer between -32768 and 32767.", Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
		}

        public GTDevmonSampleDlg()
        {
            InitializeComponent();

            Device = new GDev();
            GTDeviceStatusLabel.Text = Device.ToString();
        }

        private void GBDeviceUpdate()
        {
            if (Device.IsOpen())
            {
                UInt16 val  = Device.Read(GDev.DeviceName.GB, GBDeviceNumber);
                if (val == 0)
                {
                    GBDeviceReadEdit.Text = "0";
                }
                else
                {
                    GBDeviceReadEdit.Text = "1";
                }
            }
        }

        private void GDDeviceUpdate()
        {
            if (Device.IsOpen())
            {
                Int16 val = (Int16)Device.Read(GDev.DeviceName.GD, GDDeviceNumber);
                GDDeviceReadEdit.Text = string.Format("{0:D}", val);
            }
        }

        private void GSDeviceUpdate()
        {
            if (Device.IsOpen())
            {
                Int16 val = (Int16)Device.Read(GDev.DeviceName.GS, GSDeviceNumber);
                GSDeviceReadEdit.Text = string.Format("{0:D}", val);
            }
        }


		private void GTDevmonSampleDlg_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			if (Device.IsOpen())
			{
				if (Message_AskDisconnect() != DialogResult.OK)
				{
					e.Cancel = true;
				}
			}
		}

        private void GTDevmonSampleDlg_FormClosed(object sender, EventArgs e)
        {
            if (Device.IsOpen())
            {
                Device.Close();
            }
        }

        private void StartButton_Click(object sender, EventArgs e)
        {
            if (Device.IsOpen())
            {
                if (Message_AskDisconnect() == DialogResult.OK)
                {
                    GTDeviceStatusMapping.Text = " ";
                    GTDeviceTimer.Enabled = false;
                    StartButton.Text = "&Start monitor";
                    Device.Close();
                }
            }
            else
            {
                if (Message_AskConnect() == DialogResult.OK)
                {
                    if (Device.Open(1))
                    {
                        StartButton.Text = "&Stop monitor";
                        GTDeviceTimer.Enabled = true;
                        GTDeviceStatusMapping.Text = "*";
                    }
                    else
                    {
                        Message_ErrConnect();
                    }
                }
            }
        }

        private void GBDeviceWriteOn_Click(object sender, EventArgs e)
        {
            if (Device.IsOpen())
            {
                if (Device.Write(GDev.DeviceName.GB, GBDeviceNumber, 1))
                {
                    GBDeviceUpdate();
                }
            }
            else
            {
                Message_NotReady();
            }
        }

        private void GBDeviceWriteOff_Click(object sender, EventArgs e)
        {
            if (Device.IsOpen())
            {
                if (Device.Write(GDev.DeviceName.GB, GBDeviceNumber, 0))
                {
                    GBDeviceUpdate();
                }
            }
            else
            {
                Message_NotReady();
            }
        }

        private void GDDeviceWriteButton_Click(object sender, EventArgs e)
        {
            if (Device.IsOpen())
            {
				decimal val = GDDeviceWriteEdit.Value;
				if((-32768 <= val) && (val <= 32767))
				{
					Int16 sval = decimal.ToInt16(val);
					if (Device.Write(GDev.DeviceName.GD, GDDeviceNumber, (UInt16)sval))
					{
						GDDeviceUpdate();
					}
				}
				else
				{
					Message_ErrRangeShort();
				}
            }
            else
            {
                Message_NotReady();
            }
        }

        private void GSDeviceWriteButton_Click(object sender, EventArgs e)
        {
            if (Device.IsOpen())
            {
				decimal val = GSDeviceWriteEdit.Value;
				if((-32768 <= val) && (val <= 32767))
				{
					Int16 sval = decimal.ToInt16(val);
					if (Device.Write(GDev.DeviceName.GS, GSDeviceNumber, (UInt16)sval))
					{
						GSDeviceUpdate();
					}
				}
				else
				{
					Message_ErrRangeShort();
				}
            }
            else
            {
                Message_NotReady();
            }
        }

        private void GTDeviceTimer_Tick(object sender, EventArgs e)
        {
            GBDeviceUpdate();
            GDDeviceUpdate();
            GSDeviceUpdate();
        }

        private void GBDeviceNumberEdit_Validating(object sender, CancelEventArgs e)
        {
			decimal val = GBDeviceNumberEdit.Value;
        }

        private void GBDeviceNumberEdit_ValueChanged(object sender, EventArgs e)
        {
            GBDeviceUpdate();
        }

        private void GDDeviceNumberEdit_Validating(object sender, CancelEventArgs e)
        {
			decimal val = GDDeviceNumberEdit.Value;
		}

        private void GDDeviceNumberEdit_ValueChanged(object sender, EventArgs e)
        {
            GDDeviceUpdate();
        }

		private void GDDeviceWriteEdit_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			decimal val = GDDeviceWriteEdit.Value;
		}

        private void GSDeviceNumberEdit_Validating(object sender, CancelEventArgs e)
        {
			decimal val = GSDeviceNumberEdit.Value;
		}

        private void GSDeviceNumberEdit_ValueChanged(object sender, EventArgs e)
        {
            GSDeviceUpdate();
        }

		private void GSDeviceWriteEdit_Validating(object sender, System.ComponentModel.CancelEventArgs e)
		{
			decimal val = GSDeviceWriteEdit.Value;
		}

        public Int32 GBDeviceNumber
        {
            get
            {
                return (Int32)GBDeviceNumberEdit.Value;
            }
        }

        public Int32 GDDeviceNumber
        {
            get
            {
                return (Int32)GDDeviceNumberEdit.Value;
            }
        }

        public Int32 GSDeviceNumber
        {
            get
            {
                return (Int32)GSDeviceNumberEdit.Value;
            }
        }
    }
}
